import ctypes
import os

# Set DLL path (ใช้ bin/uareu4500.dll)
DLL_PATH = os.path.join(os.path.dirname(__file__), "bin", "uareu4500.dll")
fingerprint_lib = ctypes.CDLL(DLL_PATH, winmode=0)

# กำหนด argument/return type ให้ชัดเจน
fingerprint_lib.python_read_fingerprint_and_get_base64_string.restype = ctypes.c_char_p
fingerprint_lib.python_compare_base64_string_with_finger.argtypes = [ctypes.c_char_p]
fingerprint_lib.python_compare_base64_string_with_finger.restype = ctypes.c_int


def get_finger_reading_as_base64():
    """สแกนลายนิ้วมือและคืนค่า FMD เป็น Base64 String"""
    fmd_base64_str_ptr = fingerprint_lib.python_read_fingerprint_and_get_base64_string()
    if not fmd_base64_str_ptr:
        raise RuntimeError("Finger scan failed or returned NULL")
    base64_string = ctypes.string_at(fmd_base64_str_ptr).decode("utf-8")
    return base64_string


def compare_base64_string_with_finger_reading(base64_string):
    """
    รับ base64 ของ FMD (เช่นจาก database) ไปเปรียบเทียบกับนิ้วที่เพิ่งสแกน
    คืนค่า True (match) หรือ False (ไม่ match)
    """
    res = fingerprint_lib.python_compare_base64_string_with_finger(
        base64_string.encode("utf-8")
    )
    return bool(res)


# ตัวอย่างการใช้งาน
if __name__ == "__main__":
    print("กรุณาแตะนิ้วที่เครื่องอ่าน ...")
    base64_string = get_finger_reading_as_base64()
    print("FMD (Base64):", base64_string)

    print("ทดสอบเปรียบเทียบ FMD ที่ได้กับนิ้วเดิม ...")
    match = compare_base64_string_with_finger_reading(base64_string)
    print("Match:", match)
